﻿Imports System.IO
Imports Newtonsoft.Json

Public Class ajoutDeTache
    ' Chemin du fichier de sauvegarde
    Private Shared ReadOnly filePath As String = "taches.json"

    ' Liste des tâches de l'application
    Public Shared taches As New List(Of Tache)

    ' Méthode pour sauvegarder les données dans un fichier JSON
    Public Shared Sub SauvegarderTaches()
        Dim json As String = JsonConvert.SerializeObject(taches)
        File.WriteAllText(filePath, json)
    End Sub

    ' Méthode pour charger les données à partir du fichier JSON
    Public Shared Sub ChargerTaches()
        If File.Exists(filePath) Then
            Dim json As String = File.ReadAllText(filePath)
            taches = JsonConvert.DeserializeObject(Of List(Of Tache))(json)
        End If
    End Sub


    Private Function VerifierConflitPlageHoraire(heureDebut As DateTime, heureFin As DateTime) As Boolean
        ' Parcourir la liste des tâches existantes
        For Each tacheExistante As Tache In taches
            ' Vérifier si la plage horaire de la nouvelle tâche entre en conflit avec une tâche existante
            If (heureDebut >= tacheExistante.HeureDebut AndAlso heureDebut <= tacheExistante.HeureFin) _
            Then
                Return True ' Il y a un conflit de plage horaire
            End If
        Next

        Return False ' Aucun conflit de plage horaire
    End Function

    Private Sub AfficherRecapitulatifTaches()
        Dim recap As String = "Récapitulatif des tâches : " & vbCrLf

        For Each tache As Tache In taches
            recap &= $"Titre : {tache.Titre}, Description : {tache.Description}, Heure de début : {tache.HeureDebut}, Heure de fin : {tache.HeureFin}, Statut : {tache.Statut}" & vbCrLf
        Next

        MessageBox.Show(recap, "Récapitulatif des Tâches", MessageBoxButtons.OK, MessageBoxIcon.Information)
    End Sub

    Private Sub btn_ajoutLaTache_Click(sender As Object, e As EventArgs) Handles btn_ajoutLaTache.Click
        ' On récupère la date d'aujourd'hui (sans l'heure)
        Dim dateAujourdhui As DateTime = DateTime.Today
        ' Récupérer les valeurs saisies par l'utilisateur
        Dim titre As String = txt_titre.Text
        Dim description As String = txt_description.Text
        Dim heureDebut As DateTime = dateAujourdhui.AddHours(ctrl_heurDebut.Value.Hour).AddMinutes(ctrl_heurDebut.Value.Minute)
        Dim heureFin As DateTime = dateAujourdhui.AddHours(ctrl_heurFin.Value.Hour).AddMinutes(ctrl_heurFin.Value.Minute)

        ' Vérifier s'il y a un conflit avec les tâches existantes
        If VerifierConflitPlageHoraire(heureDebut, heureFin) Then
            MessageBox.Show("Votre tâche rentre dans une période de tâche déjà renseignée. Des tâches ne peuvent pas être enregistrées dans la même plage horaire.")
            Return ' Sortir de la fonction sans ajouter la tâche
        End If

        ' Créer une nouvelle instance de la classe Tache avec les détails saisis
        Dim nouvelleTache As New Tache(titre, description, heureDebut, heureFin)

        ' Ajouter la nouvelle tâche à la liste des tâches de l'application
        taches.Add(nouvelleTache)

        'enregistrer les donner dans un fichier JSON
        SauvegarderTaches()

        ' Afficher un message de confirmation à l'utilisateur
        MessageBox.Show("La tâche a été ajoutée avec succès !")

        ' Afficher le récapitulatif des tâches
        AfficherRecapitulatifTaches()

        ' Réinitialiser les contrôles de saisie pour permettre à l'utilisateur d'ajouter une nouvelle tâche
        txt_titre.Text = ""
        txt_description.Text = ""
        ctrl_heurDebut.Value = DateTime.Now
        ctrl_heurFin.Value = DateTime.Now
    End Sub

    Private Sub btn_next_Click(sender As Object, e As EventArgs) Handles btn_next.Click
        ' Créer une instance du formulaire de consultation des tâches
        Dim frmConsultationTaches As New vueTaches()
        ' Afficher le formulaire de consultation des tâches
        frmConsultationTaches.Show()
        ' Fermer le formulaire actuel
        Me.Close()

    End Sub

    Private Sub btn_back2_Click(sender As Object, e As EventArgs) Handles btn_back2.Click
        Me.Close()

    End Sub
End Class