﻿Public Class vueTaches
    Private Sub vueTaches_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        ' Ajouter une colonne pour l actions de modification
        Dim ModifColumn As New DataGridViewButtonColumn()
        ModifColumn.HeaderText = "Modifier"
        ModifColumn.Text = "Modifier"
        ModifColumn.UseColumnTextForButtonValue = True
        DataGridView1.Columns.Add(ModifColumn)

        ' Ajouter une colonne pour l'action de suppression
        Dim SupprimColumn As New DataGridViewButtonColumn()
        SupprimColumn.HeaderText = "Supprimer"
        SupprimColumn.Text = "Supprimer"
        SupprimColumn.UseColumnTextForButtonValue = True
        DataGridView1.Columns.Add(SupprimColumn)

        ' Ajouter les colonnes pour les détails de la tâche
        DataGridView1.Columns.Add("Titre", "Titre")
        DataGridView1.Columns.Add("Description", "Description")
        DataGridView1.Columns.Add("Heure de début", "Heure de début")
        DataGridView1.Columns.Add("Heure de fin", "Heure de fin")
        DataGridView1.Columns.Add("Statut", "Statut")

        ' Ajouter une colonne pour l'action accomplissement
        Dim accomplissementColumn As New DataGridViewButtonColumn()
        accomplissementColumn.HeaderText = "accomplissement"
        accomplissementColumn.Text = "Accompli"
        accomplissementColumn.UseColumnTextForButtonValue = True
        DataGridView1.Columns.Add(accomplissementColumn)

        ' Remplir le DataGridView avec les données des tâches
        For Each tache As Tache In ajoutDeTache.taches
            Dim rowIndex As Integer = DataGridView1.Rows.Add()
            DataGridView1.Rows(rowIndex).Cells("Titre").Value = tache.Titre
            DataGridView1.Rows(rowIndex).Cells("Description").Value = tache.Description
            DataGridView1.Rows(rowIndex).Cells("Heure de début").Value = tache.HeureDebut.ToString()
            DataGridView1.Rows(rowIndex).Cells("Heure de fin").Value = tache.HeureFin.ToString()
            DataGridView1.Rows(rowIndex).Cells("Statut").Value = tache.Statut
        Next
    End Sub

    Private Sub DataGridView1_CellContentClick(sender As Object, e As DataGridViewCellEventArgs) Handles DataGridView1.CellContentClick
        If e.ColumnIndex = 0 AndAlso TypeOf DataGridView1.Columns(e.ColumnIndex) Is DataGridViewButtonColumn Then
            ' Enregistrer les modifications des cellules
            For Each row As DataGridViewRow In DataGridView1.Rows
                ' Vérifier si la cellule n'est pas nulle avant d'accéder à sa valeur
                If Not row.Cells("Titre").Value Is Nothing AndAlso Not row.Cells("Description").Value Is Nothing AndAlso
            Not row.Cells("Heure de début").Value Is Nothing AndAlso Not row.Cells("Heure de fin").Value Is Nothing AndAlso
            Not row.Cells("Statut").Value Is Nothing Then

                    Dim titre As String = row.Cells("Titre").Value.ToString()
                    Dim description As String = row.Cells("Description").Value.ToString()
                    Dim heureDebut As DateTime = DateTime.Parse(row.Cells("Heure de début").Value.ToString())
                    Dim heureFin As DateTime = DateTime.Parse(row.Cells("Heure de fin").Value.ToString())
                    Dim statut As String = row.Cells("Statut").Value.ToString()

                    ' Mettre à jour les détails de la tâche correspondante dans la liste des tâches
                    Dim tache As Tache = ajoutDeTache.taches(row.Index)
                    tache.Titre = titre
                    tache.Description = description
                    tache.HeureDebut = heureDebut
                    tache.HeureFin = heureFin
                    tache.Statut = statut
                End If
            Next

            ' Afficher un message de confirmation
            MessageBox.Show("Les modifications ont été enregistrées avec succès !")
        ElseIf e.ColumnIndex = 1 Then
            ' Gérer l'événement de clic sur le bouton "Supprimer"
            Dim confirmation As DialogResult = MessageBox.Show("Êtes-vous sûr de vouloir supprimer cette tâche ?", "Confirmation de suppression", MessageBoxButtons.YesNo)
            If confirmation = DialogResult.Yes Then
                ' Supprimer la tâche de la liste
                ajoutDeTache.taches.RemoveAt(e.RowIndex)
                ' Mettre à jour l'affichage du DataGridView
                DataGridView1.Rows.RemoveAt(e.RowIndex)
            End If
        ElseIf e.ColumnIndex = 7 Then
            ' Gérer l'événement de clic sur le bouton "accomplissement"
            ' Mettre à jour le statut de la tâche sélectionnée en "Réussi"
            DataGridView1.Rows(e.RowIndex).Cells("Statut").Value = "Réussi"
        End If
        ajoutDeTache.SauvegarderTaches()
    End Sub

    Private Sub btn_back_Click(sender As Object, e As EventArgs) Handles btn_back.Click
        Me.Close()
    End Sub
End Class

