<?php
// c_authentification.php
require_once('./config.php');

class AuthController {
    private $conn;

    public function __construct() {
        // Connexion à la base de données
        $this->conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
    }    

    public function login() {
        if (session_status() == PHP_SESSION_NONE) {
            session_start();
        }

        // Vérifier si l'utilisateur est déjà connecté
        if (isset($_SESSION['user']) && !isset($_POST['username'])) {
            header("Location: index.php?url=dashboard");
            exit;
        }

        if ($_SERVER["REQUEST_METHOD"] == "POST") {
            // Récupérer les données du formulaire
            $username = $_POST['username'];
            $password = $_POST['password'];

            // Hacher le mot de passe 
            $hashPassword = hash('sha256', $password);

            // Vérifier la connexion
            if ($this->conn->connect_error) {
                die("Connection failed: " . $this->conn->connect_error);
            }

            // Prévenir les injections SQL
            $stmt = $this->conn->prepare("SELECT * FROM utilisateur WHERE username=? AND password_hash=?");
            $stmt->bind_param("ss", $username, $hashPassword);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows == 1) {
                // Récupérer l'utilisateur depuis la base de données
                $userData = $result->fetch_assoc();

                // Stocker les informations de l'utilisateur dans la session
                $_SESSION['nom'] = $userData['nom'];
                $_SESSION['prenom'] = $userData['prenom'];
                $_SESSION['id'] = $userData['id'];
                $_SESSION['user'] = $username;

                header("Location: index.php?url=dashboard");
                exit;
            } else {
                echo '<p style="color: red;">Nom d\'utilisateur ou mot de passe incorrect.</p>';
            }

            $this->conn->close();
        }
    }
}
?>