<?php
// index.php (routeur centralisé)
include "./vues/layout/v_header.php";
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
if (isset($_SESSION['user'])) {
    include "./vues/layout/sidebar.php";
}
// Analyse de l'URL demandée
$url = isset($_GET['url']) ? $_GET['url'] : 'login';
$route = explode('/', $url);

// Choix du contrôleur en fonction de la route spécifiée
switch ($route[0]) {
    case 'dashboard':
        include 'vues/users/U_gestionUser.php';
        break;
    case 'partage':
        include 'controleurs/c_partage.php';
        $controller = new paratgeController();
        // Choix  de la route pour les pages visiteurs.
        switch ($route[1]) {
            case 'publicationUser':
                $controller->publicationUser();
                break;
            case 'supprimer':
                $controller->deletePublication();
                break;
            case 'mecanique':
                $controller->mecanique();
                break;
            case 'bricolage':
                $controller->bricolage();
                break;
            case 'partagerSonInfo':
                $controller->partagerSonInfo();
                break;
            case 'sport':
                $controller->sport();
                break;
            case 'cuisine':
                $controller->cuisine();
                break;
            case 'social':
                $controller->social();
                break;
            case 'relation':
                $controller->relation();
                break;
            case 'decouverteLieu':
                $controller->decouverteLieu();
                break;
            case 'biodiversite':
                $controller->biodiversite();
                break;
            default:
                $controller->index();
                break;
        }
        break;
        //Fin des Choix  de la route pour les pages en fonction du domaine.
        //---------------------------------------------------------

    case 'users':
        include 'controleurs/c_usersController.php';
        $controller = new UsersController();
        $controller->createUser();
        break;
    case 'login':
    default:
        include 'vues/auth/A_login.php';
        include 'controleurs/c_authentification.php';
        $controller = new AuthController();
        $controller->login();
        break;
}

include "./vues/layout/v_footer.php";
?>
