<?php
// UserModel.php
require_once('./config.php');

class UserModel {
    private $conn;

    public function __construct() {
        // Connexion à la base de données
        $this->conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
        if ($this->conn->connect_error) {
            die("Connexion échouée: " . $this->conn->connect_error);
        }
    }

    // Méthode createUser
    public function createUser($nom, $prenom, $username, $password, $mail) {
        // Prévenir les injections SQL
        $username = $this->conn->real_escape_string($username);
        $password_hash = hash('sha256', $this->conn->real_escape_string($password));
        $nom = $this->conn->real_escape_string($nom);
        $prenom = $this->conn->real_escape_string($prenom);
        $mail = $this->conn->real_escape_string($mail);
        $date = date('Y-m-d');

        // Créer un nouvel utilisateur dans la base de données
        $stmt = $this->conn->prepare("INSERT INTO utilisateur (nom, prenom, username, email, password_hash, dateInscription) VALUES (?, ?, ?, ?, ?, ?)");
        if ($stmt === false) {
            die("Erreur de préparation de la requête: " . $this->conn->error);
        }
        $stmt->bind_param("ssssss", $nom, $prenom, $username, $mail, $password_hash, $date);

        if ($stmt->execute()) {
            echo '<span style="color: green; font-weight: bold;">Utilisateur créé avec succès.</span> <a href="index.php"> Se connecter 🖥</a>';
        } else {
            echo '<span style="color: red; font-weight: bold;">Erreur lors de la création de l\'utilisateur:</span> ' . $stmt->error;
        }

        $stmt->close();
        $this->conn->close();
    }
}
?>
