<?php
// model/PartageDonneeModel.php
require_once('./config.php');
class PartageDonnee {
    private $conn;

    public function __construct() {
        // Connexion à la base de données
        $this->conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
    }
    public function partagerSonInfo() {
        if ($_SERVER["REQUEST_METHOD"] == "POST") {
            // Vérifier si les données du formulaire sont envoyées
            if (isset($_POST['type']) && isset($_POST['domaine']) && isset($_POST['titre']) && isset($_POST['description']) && isset($_POST['contenu'])) {
                // Récupération des données du formulaire
                $type = $_POST['type'];
                $domaine = $_POST['domaine'];
                $titre = $_POST['titre'];
                $description = $_POST['description'];
                $contenu = $_POST['contenu']; // Contenu édité par CKEditor
                $idUtilisateur = $_SESSION['id'];
                $datePublication = date("Y-m-d H:i");
    
                // Préparation de la requête SQL d'insertion en fonction du type
                switch ($type) {
                    case 'astuce':
                        $sql = "INSERT INTO astuce (domaine, titre, descriptionn, contenu,datePublication,idUtilisateur) VALUES (?, ?, ?, ?,?, ?)";
                        break;
                    case 'culture':
                        $sql = "INSERT INTO culture (domaine, titre, descriptionn, contenu,datePublication ,idUtilisateur) VALUES (?, ?, ?, ?,?, ?)";
                        break;
                    case 'idee':
                        $sql = "INSERT INTO idee (domaine, titre, descriptionn, contenu,datePublication ,idUtilisateur) VALUES (?, ?, ?, ?,?, ?)";
                        break;
                    default:
                        echo "Type invalide";
                        return;
                }
                
                // Préparation de la requête
                $stmt = $this->conn->prepare($sql);
    
                // Exécution de la requête avec les données du formulaire et l'ID utilisateur de la session
                $stmt->execute([$domaine, $titre, $description, $contenu, $datePublication, $idUtilisateur]);
    
                // Redirection vers une autre page après l'enregistrement
                
                echo "PUBLIER ‼";
                exit;
            } else {
                // Les données du formulaire sont manquantes
                echo "Erreur: Les données du formulaire sont manquantes.";
            }
        
        }
    }
    
    public function fetchDonneeUser($table) {
        // Méthode pour récupérer toutes les données de l'utilisateur depuis la base de données en fonction de la table spécifiée
        $sql = "SELECT $table.*, utilisateur.nom, utilisateur.prenom FROM $table JOIN utilisateur ON $table.idUtilisateur = utilisateur.id WHERE idUtilisateur = ?";
        $stmt = $this->conn->prepare($sql);
        $userId = $_SESSION['id'] ; // Récupération de l'ID de l'utilisateur connecté depuis la session
        $stmt->bind_param('i', $userId);
        $stmt->execute();
        $result = $stmt->get_result();
        $data = [];
        while ($row = $result->fetch_assoc()) {
            $data[] = $row;
        }
        return $data;
    } 
    
    public function fetchData($table, $domaine) {
        // Méthode pour récupérer les données depuis la base de données en fonction de la table et du domaine spécifiés
        $sql = "SELECT $table.*, utilisateur.nom, utilisateur.prenom FROM $table JOIN utilisateur ON $table.idUtilisateur = utilisateur.id WHERE $table.domaine = ?";
        $stmt = $this->conn->prepare($sql);
        $stmt->bind_param('s', $domaine);
        $stmt->execute();
        $result = $stmt->get_result();
        $data = [];
        while ($row = $result->fetch_assoc()) {
            $data[] = $row;
        }
        return $data;
    }
    public function fetchPublicationUser($table) {
        // Méthode pour récupérer les données de l'utilisateur connecté depuis la base de données
        return $this->fetchDonneeUser($table);
    }
    
    public function deletePublication($nomTable, $userId, $publicationId) {
        // Vérifier si les paramètres ne sont pas NULL
        if ($nomTable !== null && $userId !== null && $publicationId !== null) {
            // Appeler la procédure stockée pour supprimer la publication
            $sql = "CALL deletePublication(?, ?, ?)";
            $stmt = $this->conn->prepare($sql);
            $stmt->bind_param('sii', $nomTable, $userId, $publicationId); // 'sii' indique les types des paramètres : string, integer, integer
            $stmt->execute();
            // Rediriger vers une la page v_publicationUSER après la suppression réussie
            echo '<span style="color: green; font-weight: bold;">Publication supprimé.</span> <a href="index.php?url=partage/publicationUser"> Revenir à mes publication 🖥</a>';
            exit(); 

        } else {
            // Gérer le cas où l'un des paramètres est NULL
            echo "Erreur : l'un des paramètres de la publication est NULL.";
        }
    }
    
    public function fetchMecanique($table) {
        // Méthode pour récupérer les données de mécanique depuis la base de données
        return $this->fetchData($table, 'mecanique');
    }

    public function fetchBricolage($table) {
        // Méthode pour récupérer les données de bricolage depuis la base de données
        return $this->fetchData($table, 'bricolage');
    }

    public function fetchSport($table) {
        // Méthode pour récupérer les données de sport depuis la base de données
        return $this->fetchData($table, 'sport');
    }

    public function fetchCuisine($table) {
        // Méthode pour récupérer les données de cuisine depuis la base de données
        return $this->fetchData($table, 'cuisine');
    }

    public function fetchSocial($table) {
        // Méthode pour récupérer les données de social depuis la base de données
        return $this->fetchData($table, 'social');
    }

    public function fetchRelation($table) {
        // Méthode pour récupérer les données de relation depuis la base de données
        return $this->fetchData($table, 'relation');
    }

    public function fetchDecouverteLieu($table) {
        // Méthode pour récupérer les données de découverte de lieux depuis la base de données
        return $this->fetchData($table, 'decouverteLieu');
    }

    public function fetchBiodiversite($table) {
        // Méthode pour récupérer les données de biodiversité depuis la base de données
        return $this->fetchData($table, 'biodiversite');
    }

}
?>